# LRU 缓存机制

<div class="title__3Vvk">运用你所掌握的数据结构，设计和实现一个  <a href="https://baike.baidu.com/item/LRU" target="_blank">LRU (最近最少使用) 缓存机制</a> 。</div>

<div class="original__bRMd">
<div>
<p>实现 <code>LRUCache</code> 类：</p>

<ul>
	<li><code>LRUCache(int capacity)</code> 以正整数作为容量 <code>capacity</code> 初始化 LRU 缓存</li>
	<li><code>int get(int key)</code> 如果关键字 <code>key</code> 存在于缓存中，则返回关键字的值，否则返回 <code>-1</code> 。</li>
	<li><code>void put(int key, int value)</code> 如果关键字已经存在，则变更其数据值；如果关键字不存在，则插入该组「关键字-值」。当缓存容量达到上限时，它应该在写入新数据之前删除最久未使用的数据值，从而为新的数据值留出空间。</li>
</ul>

<p> </p>
</div>
</div>

<p><strong>进阶</strong>：你是否可以在 <code>O(1)</code> 时间复杂度内完成这两种操作？</p>

<p> </p>

<p><strong>示例：</strong></p>

<pre>
<strong>输入</strong>
["LRUCache", "put", "put", "get", "put", "get", "put", "get", "get", "get"]
[[2], [1, 1], [2, 2], [1], [3, 3], [2], [4, 4], [1], [3], [4]]
<strong>输出</strong>
[null, null, null, 1, null, -1, null, -1, 3, 4]

<strong>解释</strong>
LRUCache lRUCache = new LRUCache(2);
lRUCache.put(1, 1); // 缓存是 {1=1}
lRUCache.put(2, 2); // 缓存是 {1=1, 2=2}
lRUCache.get(1);    // 返回 1
lRUCache.put(3, 3); // 该操作会使得关键字 2 作废，缓存是 {1=1, 3=3}
lRUCache.get(2);    // 返回 -1 (未找到)
lRUCache.put(4, 4); // 该操作会使得关键字 1 作废，缓存是 {4=4, 3=3}
lRUCache.get(1);    // 返回 -1 (未找到)
lRUCache.get(3);    // 返回 3
lRUCache.get(4);    // 返回 4
</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>1 <= capacity <= 3000</code></li>
	<li><code>0 <= key <= 10000</code></li>
	<li><code>0 <= value <= 10<sup>5</sup></code></li>
	<li>最多调用 <code>2 * 10<sup>5</sup></code> 次 <code>get</code> 和 <code>put</code></li>
</ul>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp

```

## 答案

```cpp
class LRUCache
{
public:
    LRUCache(int capacity) : cap(capacity) {}

    int get(int key)
    {
        if (m.count(key) != 0)
        {
            int val = m[key]->second;
            l.erase(m[key]);
            l.push_front({key, val});
            m[key] = l.begin();
            return val;
        }
        return -1;
    }

    void put(int key, int value)
    {
        if (m.count(key) != 0)
        {
            l.erase(m[key]);
            l.push_front({key, value});
            m[key] = l.begin();
        }
        else
        {
            m.erase(l.back().first);
            l.pop_back();
            l.push_front({key, value});
            m[key] = l.begin();
        }
    }

private:
    int cap;
    list<pair<int, int>> l;
    unordered_map<int, list<pair<int, int>>::iterator> m;
};
```
## 选项


### A

```cpp
class LRUCache
{
private:
    unordered_map<int, DLinkedNode *> cache;
    DLinkedNode *head;
    DLinkedNode *tail;
    int size;
    int capacity;

public:
    LRUCache(int _capacity) : capacity(_capacity), size(0)
    {

        head = new DLinkedNode();
        tail = new DLinkedNode();
        head->next = tail;
        tail->prev = head;
    }

    int get(int key)
    {
        if (!cache.count(key))
        {
            return -1;
        }

        DLinkedNode *node = cache[key];
        moveToHead(node);
        return node->value;
    }

    void put(int key, int value)
    {
        if (!cache.count(key))
        {

            DLinkedNode *node = new DLinkedNode(key, value);

            cache[key] = node;

            addToHead(node);
            ++size;
            if (size > capacity)
            {

                DLinkedNode *removed = removeTail();

                cache.erase(removed->key);

                delete removed;
                --size;
            }
        }
        else
        {

            DLinkedNode *node = cache[key];
            node->value = value;
            moveToHead(node);
        }
    }

    void addToHead(DLinkedNode *node)
    {
        node->prev = head;
        node->next = head->next;
        head->next->prev = node;
        head->next = node;
    }

    void removeNode(DLinkedNode *node)
    {
        node->prev->next = node->next;

        node->next->prev = node->prev;
    }

    void moveToHead(DLinkedNode *node)
    {
        removeNode(node);
        addToHead(node);
    }

    DLinkedNode *removeTail()
    {
        DLinkedNode *node = tail->prev;
        removeNode(node);
        return node;
    }
};
```

### B

```cpp
class LRUCache
{
private:
    int capacity;
    list<pair<int, int>> cl;
    unordered_map<int, list<pair<int, int>>::iterator> cm;

public:
    LRUCache(int capacity)
    {
        this->capacity = capacity;
    }

    int get(int key)
    {
        auto it = cm.find(key);
        if (it != cm.end())
        {
            pair<int, int> p = *cm[key];
            int value = p.second;
            cl.erase(cm[key]);
            cl.push_front(p);
            cm[key] = cl.begin();
            return value;
        }
        else
            return -1;
    }

    void put(int key, int value)
    {
        auto it = cm.find(key);
        if (it != cm.end())
        {
            cl.erase(cm[key]);
            cl.push_front({key, value});
            cm[key] = cl.begin();
        }
        else
        {
            if (cl.size() == capacity)
            {
                int old_key = cl.back().first;
                cl.pop_back();
                cm.erase(old_key);
            }
            cl.push_front({key, value});
            cm.insert({key, cl.begin()});
        }
    }
};
```

### C

```cpp
class LRUCache
{
private:
    int capacity, size;
    list<int> cl;
    unordered_map<int, int> cm;

public:
    LRUCache(int capacity)
    {
        this->capacity = capacity;
        size = 0;
    }

    int get(int key)
    {
        auto it = cm.find(key);
        if (it != cm.end())
        {
            cl.remove(key);
            cl.push_back(key);
            return it->second;
        }
        else
            return -1;
    }

    void put(int key, int value)
    {
        auto it = cm.find(key);
        if (it != cm.end())
        {
            it->second = value;
            cl.remove(key);
            cl.push_back(key);
        }
        else
        {
            if (size == capacity)
            {
                int old_key = cl.front();
                cl.pop_front();
                cm.erase(old_key);
                size--;
            }
            cl.push_back(key);
            cm.insert({key, value});
            size++;
        }
    }
};
```
